<?php
/*--------------------------------------------------------------
   WidgetDatabaseEntries.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections;

use ArrayIterator;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDatabaseEntry;
use IteratorAggregate;

class WidgetDatabaseEntries implements IteratorAggregate
{
    /**
     * @var WidgetDatabaseEntry[]
     */
    private $values;
    
    
    /**
     * Constructor.
     */
    private function __construct(array $values)
    {
        $this->values = $values;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(WidgetDatabaseEntry ...$widgetDatabaseEntries): self
    {
        return new self($widgetDatabaseEntries);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): ArrayIterator
    {
        return new ArrayIterator($this->values);
    }
}